class GameSetup expands Mutator config(GameSetup2k14);

// GameName vars
var config string DMGameName, TDMGameName, CTFGameName, DOMGameName, ASGameName;

// LeftMessage vars
var config string DMLeftMessage, TDMLeftMessage, CTFLeftMessage, DOMLeftMessage, ASLeftMessage;

// EnteredMessage vars
var config string DMEnteredMessage, TDMEnteredMessage, CTFEnteredMessage, DOMEnteredMessage, ASEnteredMessage;

//Misc Variables:
var config bool 	bUseGlobalStats;
var config string	GlobalStatsURL,
					GlobalStatsPath;
var config bool		bNulledCarcasses,
					bTransparentCarcasses,
					bAllWeapons,
					bFullyLoaded,
					bGiveRedeemer,
					bNoInvisibility,
					bNoArmor,
					bNoThighPads,
					bNoDamageAmplifier,
					bNoShieldbelt,
					bNoJumpboots,
					bNoHealthvials,
					bNoMedBoxes,
					bNoSuperHealth,
					bHeadShotBonus,
					bIgnoreMaxAmmo;
var config int		HeadShotHealthReward,
					HeadShotMaxHealth,
					HeadShotFragBonus,
					HeadShotAmmoReward,
					NumJumps;
var config bool		bHiddenAdmin,
					bNoFeigningDeath;
var config string	FeignDeathMessage;


//Revenge mod variables:
var pawn killers[32], player[32];				
var config bool	bUseRevenge,
				bIgnoreMaxAmmoR;
var config int	RevengeHealthReward,
				RevengeMaxHealth,
				RevengeFragBonus,
				RevengeAmmoReward;

//Pinata mod variables:
var config bool	bPinata;

//Soulmode settings:
var config bool		bSoulmode,
					bIgnoreMaxAmmoC;
var config int		LifeTime,
					SoulScore,
					SoulHealth,
					SoulMaxHealth,
					SoulAmmo;
var config string	SoulMessage;

//Dependency classes:
var Actor IpToCountry;

//ACE mod variables:
var string	   PlayerName[32];
var string     UTCommandLine[32];       // Commandline of the application
var string     UTVersion[32];           // UT Client version
var string     CPUIdentifier[32];       // CPU Identifier string
var string     CPUMeasuredSpeed[32];    // CPU Measured speed
var string     CPUReportedSpeed[32];    // CPU Reported speed - trough the commandline
var string     OSString[32];            // Full OS Version string
var string     NICName[32];             // Full name of the primary network interface
var string     MACHash[32];             // MD5 hash of the primary mac address
var string     UTDCMacHash[32];         // UTDC compatible hash of the mac address
var string     HWHash[32];              // MD5 hash of the hardware ID
var string     CoreMD5[32];             // MD5 hash of the core.dll file
var string     EngineMD5[32];           // MD5 hash of the engine.dll file
var string     RenderMD5[32];           // MD5 hash of the render.dll file
var string     GalaxyMD5[32];           // MD5 hash of the galaxy.dll file
var string     WinDrvMD5[32];           // MD5 hash of the windrv.dll file
var string     WindowMD5[32];           // MD5 hash of the window.dll file
var string     RenderDeviceClass[32];   // Class of the renderdevice (eg: OpenGLDrv.OpenGLRenderDevice)
var string     RenderDeviceFile[32];    // DLL file of the renderdevice
var string     RenderDeviceMD5[32];     // MD5 hash of the renderdevice dll file
var string     SoundDeviceClass[32];    // Class of the sounddevice (eg: OpenAL.OpenALDevice)
var string     SoundDeviceFile[32];     // DLL file of the sounddevice
var string     SoundDeviceMD5[32];      // MD5 hash of the sounddevice file
var string     ACEMD5[32];              // MD5 hash of the ace module
var string     bTunnel[32];             // Is the user behind a UDP Proxy/Tunnel? NOTICE!!!! This variable is a boolean in IACECheck class!!!!!!
var string     RealIP[32];              // RealIP of the player (only set if bTunnel == true)
var string     bWine[32];               // Is the client running UT using the Wine Emulator? NOTICE!!!! This variable is a boolean in IACECheck class!!!!!!
var config int	ACEModDelay;

//ACE mod - Check if player should be added to ACE array:
function CheckACEPlayers()
{
local Pawn P;
local int i;
local RI PRI;
Local Actor ACE;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if ( P.IsA('PlayerPawn') )
			{
			PRI = RI(P.PlayerReplicationInfo);
			
			if ( !PRI.bAddedToACEArray && PRI.TimeInGame > ACEModDelay && PRI.PlayerName != "Player" )
				{
				for (i=0;i<32;i++)
					{
					if ( PRI.PlayerName == PlayerName[i] || PlayerName[i] == "" )
						{
						//assign all ACE variables to the array:
						ForEach AllActors(class'Actor', ACE)
							{
							if ( ACE.IsA('IACECheck') )
								{
								if ( IACECheck(ACE).PlayerName == PRI.PlayerName )
									{
									log ("Game Setup ACE mod - Player:"@PRI.PlayerName@"is beeing added to the array.");
									//Players ACE info class found, now copy variables to array:
									PlayerName[i] = PRI.PlayerName;
									UTCommandLine[i] = IACECheck(ACE).UTCommandLine;
									UTVersion[i] = IACECheck(ACE).UTVersion;
									CPUIdentifier[i] = IACECheck(ACE).CPUIdentifier;
									CPUMeasuredSpeed[i] = IACECheck(ACE).CPUMeasuredSpeed;
									CPUReportedSpeed[i] = IACECheck(ACE).CPUReportedSpeed;
									OSString[i] = IACECheck(ACE).OSString;
									NICName[i] = IACECheck(ACE).NICName;
									MACHash[i] = IACECheck(ACE).MACHash;
									UTDCMacHash[i] = IACECheck(ACE).UTDCMacHash;
									HWHash[i] = IACECheck(ACE).HWHash;
									CoreMD5[i] = IACECheck(ACE).CoreMD5;
									EngineMD5[i] = IACECheck(ACE).EngineMD5;
									RenderMD5[i] = IACECheck(ACE).RenderMD5;
									GalaxyMD5[i] = IACECheck(ACE).GalaxyMD5;
									WinDrvMD5[i] = IACECheck(ACE).WinDrvMD5;
									WindowMD5[i] = IACECheck(ACE).WindowMD5;
									RenderDeviceClass[i] = IACECheck(ACE).RenderDeviceClass;
									RenderDeviceFile[i] = IACECheck(ACE).RenderDeviceFile;
									RenderDeviceMD5[i] = IACECheck(ACE).RenderDeviceMD5;
									SoundDeviceClass[i] = IACECheck(ACE).SoundDeviceClass;
									SoundDeviceFile[i] = IACECheck(ACE).SoundDeviceFile;
									SoundDeviceMD5[i] = IACECheck(ACE).SoundDeviceMD5;
									ACEMD5[i] = IACECheck(ACE).ACEMD5;
									if ( IACECheck(ACE).bTunnel )
										bTunnel[i] = "True"; // NOTICE!!!! This variable is a boolean in IACECheck class, but string variable here because of array!!!!!!
									else
										bTunnel[i] = "False";
									RealIP[i] = IACECheck(ACE).RealIP;
									if ( IACECheck(ACE).bWine )
										bWine[i] = "True"; // NOTICE!!!! This variable is a boolean in IACECheck class, but string variable here because of array!!!!!!
									else
										bWine[i] = "False";
									PRI.bAddedToACEArray = True;
									log("Game Setup ACE mod: Player"@PRI.PlayerName@"Was logged successfully.");
									}
								}
							}
						i = 999;
						}
					}
				}
			}
		}
}

//Revenge mod function to assign an ID for each pawn
function listPlayers()
{
local Pawn P;
local int i;
	i = 0;
	for(P = Level.Pawnlist; P != None; P = P.Nextpawn)
		{
		player[i] = P;
		i++;
		}
}
				
function PreBeginPlay()
{
	SaveConfig();
	
	log ("#-------------------------------#");
	log ("| Game Setup mutator by TheDane |");
	log ("| www.unrealtournament.info     |");
	log ("#-------------------------beta2-#");
	
	switch (Level.Game.Default.GameName)
		{
			case "Tournament DeathMatch":
				Level.Game.ScoreBoardType = Class'DM_SB';
				Level.Game.HUDType = Class'DM_HUD';
				Level.Game.GameName = DMGameName;
				Level.Game.LeftMessage = DMLeftMessage;
				Level.Game.EnteredMessage = DMEnteredMessage;
			break;
			
			/*
			
			case "Tournament Team Game":
				Level.Game.ScoreBoardType = Class'TDM_SB';
				if ( bEFFonTDMHUD )
					{
					Level.Game.HUDType = Class'TDM_HUD';
					}
				Level.Game.GameName = TDMGameName;
				Level.Game.LeftMessage = TDMLeftMessage;
				Level.Game.EnteredMessage = TDMEnteredMessage;
			break;
			case "Capture the Flag":
				Level.Game.ScoreBoardType = Class'CTF_SB';
				if ( bEFFonCTFHUD )
					{
					Level.Game.HUDType = Class'CTF_HUD';
					}
				Level.Game.GameName = CTFGameName;
				Level.Game.LeftMessage = CTFLeftMessage;
				Level.Game.EnteredMessage = CTFEnteredMessage;
			break;
			case "Domination":
				Level.Game.ScoreBoardType = Class'DOM_SB';
				if ( bEFFonDOMHUD )
					{
					Level.Game.HUDType = Class'DOM_HUD';
					}
				Level.Game.GameName = DOMGameName;
				Level.Game.LeftMessage = DOMLeftMessage;
				Level.Game.EnteredMessage = DOMEnteredMessage;
			break;
			case "Assault":
				Level.Game.ScoreBoardType = Class'AS_SB';
				if ( bEFFonDOMHUD )
					{
					Level.Game.HUDType = Class'AS_HUD';
					}
				Level.Game.GameName = ASGameName;
				Level.Game.LeftMessage = ASLeftMessage;
				Level.Game.EnteredMessage = ASEnteredMessage;
			break;
			
			*/
			
			default:
			return;
		}
	
	//GlobalStats:
	if ( bUseGlobalStats )
		{
		Level.Game.BaseMutator.AddMutator(Level.Spawn(class'GlobalStats'));
		}
	
	SetTimer(1.0,True);
	
	Super.PreBeginPlay();
}

function PostBeginPlay()
{
	BindIpToCountry();
}

function bool BindIpToCountry()
{
local Actor A;
	foreach AllActors(class'Actor', A, 'LinkActor')
		IpToCountry = A;
	if ( IpToCountry != none )
		log("IP2C info: LinkActor found.");
	else
		log("IP2C info: ERROR - LinkActor not found.");
}

function string GetIpInfo(string IP)
{
	if(IpToCountry != None)
		return IpToCountry.GetItemName(IP);
}

function bool AlwaysKeep(Actor Other) 
{
	if (Other.IsA('PlayerPawn'))
        {
		PlayerPawn(Other).PlayerReplicationInfoClass = class'RI';
		return true;
		}
		
	if ( Other.IsA('Carcass') )
		{
		if ( bTransparentCarcasses )
			Carcass(Other).Style = STY_Translucent;
		if ( bNulledCarcasses )
			{
			Carcass(Other).bProjTarget = False;
			Carcass(Other).bBlockPlayers = False;
			}
		}
		
	if ( Other.IsA('UT_JumpBoots') )
		{
		UT_JumpBoots(Other).Charge = NumJumps;
		}
		
	if ( Other.IsA('GlobalStats') )
		{
		GlobalStats(Other).URL = GlobalStatsURL;
		GlobalStats(Other).Path = GlobalStatsPath;
		}
	if ( Other.IsA('GlobalStatsWEBLink') )
		{
		GlobalStatsWEBLink(Other).URL = GlobalStatsURL;
		GlobalStatsWEBLink(Other).Path = GlobalStatsPath;
		}
		
	if (NextMutator != None)
		return (NextMutator.AlwaysKeep(Other));
	
	return false;
}

function Timer()
{
local Pawn P;
local string IP;
local String Country;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if ( P.IsA('PlayerPawn') )
			{
			IP = PlayerPawn(P).GetPlayerNetworkAddress();
			IP = Left(IP, InStr(IP, ":"));
			Country = GetIpInfo(IP);
			if ( Left(Country, 1) != "!" && Country != "" && RI(PlayerPawn(P).PlayerReplicationInfo).Country == "")
				{
				//log(PlayerPawn(P).PlayerReplicationInfo.Playername@"IP2C info:"@Country);
				RI(PlayerPawn(P).PlayerReplicationInfo).Country = Country;
				}
			//else
				//log(PlayerPawn(P).PlayerReplicationInfo.Playername@"IP2C info:"@IP);
			}
		}

	if ( bSoulmode )
		{
		CrossLifeControl();
		}
	
	//ACE mod, check if all players are added to the array:
	CheckACEPlayers();
}

function Soulmode(Pawn Killed,Pawn Killer)
{
local Cross DropItem;

       if ( Killed != none && Killer != none && Killed != Killer )
		{
        DropItem = Spawn(Class'Cross',,,Killed.Location);
		if ( DropItem != none )
			{
			DropItem.Claimer = Killer;
			DropItem.LifeTime = LifeTime;
			DropItem.SoulScore = SoulScore;
			DropItem.SoulHealth = SoulHealth;
			DropItem.SoulMaxHealth = SoulMaxHealth;
			DropItem.SoulAmmo = SoulAmmo;
			DropItem.bIgnoreMaxAmmoC = bIgnoreMaxAmmoC;
			DropItem.SoulMessage = SoulMessage;
			DropItem.DrawScale = 0.75;
			DropItem.RemoteRole = ROLE_DumbProxy;
			DropItem.SetPhysics(PHYS_Falling);
			DropItem.bCollideWorld = true;
			DropItem.RespawnTime = 0.0;
			DropItem.bRotatingPickup = False;
			}
		}
}

function CrossLifeControl()
{
local Cross Soul;

	ForEach AllActors(class'Cross', Soul)
		{
		Soul.LifeTime--;
		if ( Soul.LifeTime <= 0 )
			{
			Spawn(Class'BotPack.UT_SpriteSmokePuff',,,Soul.Location);
			Soul.Destroy();
			}
		}
}

function bool PreventDeath (Pawn Killed, Pawn Killer, name damageType, vector HitLocation)
{

	//Check for headshot rewards:
	if ( bHeadShotBonus && damageType == 'decapitated' && Killer.IsA('PlayerPawn') )
		{
		if ( HeadShotHealthReward > 0 )
			{
			Killer.Health += HeadShotHealthReward;
			if ( Killer.Health > HeadShotMaxHealth )
				Killer.Health = HeadShotMaxHealth;
			}
		if ( HeadShotFragBonus > 0 )
			Killer.PlayerReplicationInfo.Score += HeadShotFragBonus;
		if ( HeadShotAmmoReward > 0 && Killer.Weapon.AmmoType != none )
			{
			Killer.Weapon.AmmoType.AmmoAmount += HeadShotAmmoReward;
			if ( !bIgnoreMaxAmmo )
				{
				if ( Killer.Weapon.AmmoType.AmmoAmount > Killer.Weapon.AmmoType.MaxAmmo )
					Killer.Weapon.AmmoType.AmmoAmount = Killer.Weapon.AmmoType.MaxAmmo;
				}
			}
		}

	if ( bPinata )
		Pinata(Killed);
	
	if ( bSoulmode )
		Soulmode(Killed,Killer);
		
	if ( NextMutator != None )
		{
		NextMutator.PreventDeath(Killer, Killed, damageType, HitLocation);
		}	
}

function Pinata(Pawn Killed)
{
local actor dropped;
local float speed;
local inventory inv;
local weapon weap;
local int AmmoCount, InvCharge;

	for (inv=Killed.Inventory; inv!=None; inv=inv.Inventory)
		{	
		if (inv.IsA('Weapon') && !inv.IsA('ImpactHammer') && !inv.IsA('Translocator') )
			{
			weap = Weapon(inv);
			AmmoCount = Weap.AmmoType.AmmoAmount;
			dropped = Spawn(weap.Class,,,Killed.Location);
			speed = VSize(Killed.Velocity);
			dropped.RemoteRole = ROLE_DumbProxy;
			dropped.SetPhysics(PHYS_Falling);
			dropped.bCollideWorld = true;
			dropped.Velocity = Normal(Killed.Velocity/speed + 0.5 * VRand()) * (speed + 280);
			weap = Weapon(dropped);
			weap.PickupAmmoCount = AmmoCount;

			if ( weap != None )
				{
				weap.RespawnTime = 0.0;
				weap.BecomePickup();
				weap.bTossedOut = true;
				weap.bWeaponStay = false;
				weap.GotoState('PickUp', 'Dropped');
				}
			
			}
		else if ( Ammo(inv) == None && !inv.IsA('ImpactHammer') && !inv.IsA('Translocator') )
			{
			dropped = Spawn(inv.Class,,,Killed.Location);
			InvCharge = Inventory(dropped).Charge;
			inv = Inventory(dropped);
			inv.Charge = InvCharge;
			if (inv != None)
				{
				inv.RespawnTime = 0.0;
				inv.BecomePickup();
				}
			}
		Killed.Inventory.Destroy();
		}
}

function ModifyPlayer(Pawn Other)
{
	if ( bAllWeapons )
		{
		GiveWeapon(Other, "Botpack.PulseGun");
		GiveWeapon(Other, "Botpack.ShockRifle");
		GiveWeapon(Other, "Botpack.UT_FlakCannon");
		GiveWeapon(Other, "Botpack.UT_BioRifle");
		GiveWeapon(Other, "Botpack.Minigun2");
		GiveWeapon(Other, "Botpack.SniperRifle");
		GiveWeapon(Other, "Botpack.Ripper");
		GiveWeapon(Other, "Botpack.UT_Eightball");
		if ( bGiveRedeemer )
			GiveWeapon(Other, "Botpack.WarheadLauncher");
		}
	
	//update revengemod's pawn array:
	if ( bUseRevenge )
		listPlayers();
	
	if ( NextMutator != None )
		NextMutator.ModifyPlayer(Other);
}

function ScoreKill(Pawn Killer, Pawn Other)
{
local int i, j;
local Pawn P;

	//Revenge mod:
	if (bUseRevenge && Other != Killer)
		{
		for(j = 0; j < 32; j++)
			{
			if(player[j] == Other)	// if it's the victim
				{
				for(i = 0; i < 32; i++)
					{
					if(player[i] == Killer)
						{
						killers[j] = Killer;	// store his killer
						}
					}
				}
			else if(player[j] == Killer)	// if it's the killer
				{
				if (killers[j] == Other)	// and he killed his last killer
					{
					//Now reward player that had revenge:
					if ( RevengeHealthReward > 0 )
						{
						Killer.Health += RevengeHealthReward;
						if ( Killer.Health > RevengeMaxHealth )
							Killer.Health = RevengeMaxHealth;
						}
					if ( RevengeFragBonus > 0 )
						{
						Killer.Health += RevengeFragBonus;
						}
					if ( RevengeAmmoReward > 0 && Killer.Weapon.AmmoType != none )
						{
						Killer.Weapon.AmmoType.AmmoAmount += RevengeAmmoReward;
						if ( !bIgnoreMaxAmmoR )
							{
							if ( Killer.Weapon.AmmoType.AmmoAmount > Killer.Weapon.AmmoType.MaxAmmo )
								Killer.Weapon.AmmoType.AmmoAmount = Killer.Weapon.AmmoType.MaxAmmo;
							}
						}
					for ( P=Level.PawnList; P!=None; P=P.NextPawn )
						if ( P.IsA('TournamentPlayer') )
							P.ReceiveLocalizedMessage( class'RevengeMessage', 0, Killer.PlayerReplicationInfo, Other.PlayerReplicationInfo);
					}
				killers[j] = None;	// set his last killer to none (only one chance for revenge: the very next kill...)
				}
			}
		}
	if ( NextMutator != None )
		{
		NextMutator.ScoreKill(killer, other);
		}
}

function GiveWeapon(Pawn PlayerPawn, string aClassName )
{
local class<Weapon> WeaponClass;
local Weapon NewWeapon;

	WeaponClass = class<Weapon>(DynamicLoadObject(aClassName, class'Class'));

	if( PlayerPawn.FindInventoryType(WeaponClass) != None )
		return;
		
	newWeapon = Spawn(WeaponClass);
	
	if( newWeapon != None )
		{
		newWeapon.RespawnTime = 0.0;
		newWeapon.GiveTo(PlayerPawn);
		newWeapon.bHeldItem = true;
		newWeapon.GiveAmmo(PlayerPawn);
		newWeapon.SetSwitchPriority(PlayerPawn);
		newWeapon.WeaponSet(PlayerPawn);
		newWeapon.AmbientGlow = 0;
		
		if ( PlayerPawn.IsA('PlayerPawn') )
			newWeapon.SetHand(PlayerPawn(PlayerPawn).Handedness);
		else
			newWeapon.GotoState('Idle');
			
		PlayerPawn.Weapon.GotoState('DownWeapon');
		PlayerPawn.PendingWeapon = None;
		PlayerPawn.Weapon = newWeapon;
		
		if ( bFullyLoaded )
			newWeapon.AmmoType.AmmoAmount = newWeapon.AmmoType.MaxAmmo;
		}
}

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	if ( Other.IsA('UT_Invisibility') && bNoInvisibility )
		{
		ReplaceWith(Other,"PathNode");
			return false;
		}
	if ( Other.IsA('Armor2') && bNoArmor )
		{
		ReplaceWith(Other,"PathNode");
			return false;
		}
	if ( Other.IsA('ThighPads') && bNoThighPads )
		{
		ReplaceWith(Other,"PathNode");
			return false;
		}
	if ( Other.IsA('UDamage') && bNoDamageAmplifier )
		{
		ReplaceWith(Other,"PathNode");
			return false;
		}
	if ( Other.IsA('UT_ShieldBelt') && bNoShieldbelt )
		{
		ReplaceWith(Other,"PathNode");
			return false;
		}
	if ( Other.IsA('UT_JumpBoots') && bNoJumpboots )
		{
		ReplaceWith(Other,"PathNode");
			return false;
		}
	if ( Other.IsA('HealthVial') && bNoHealthvials )
		{
		ReplaceWith(Other,"PathNode");
			return false;
		}
	if ( Other.IsA('MedBox') && bNoMedBoxes )
		{
		ReplaceWith(Other,"PathNode");
			return false;
		}
	if ( Other.IsA('HealthPack') && bNoSuperHealth )
		{
		ReplaceWith(Other,"PathNode");
			return false;
		}
	
	return true; 
}

function Tick(float DeltaTime)
{
local Pawn P;
local Inventory Inv;
local bool bIsAmmoCheating,bGotJumpBoots;
local int NumAmmo;

	Super.Tick(DeltaTime);

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if ( P.IsA('PlayerPawn') )
			{
			//Monitor if player is an admin:
			if ( PlayerPawn(P).PlayerReplicationInfo.bAdmin )
				{
				//Player is admin, now disable the ability to use admin status to cheat:
				if ( PlayerPawn(P).ReducedDamageType == 'All' )
					{
					//Admin is playing god!!
					if ( bHiddenAdmin)
						BroadcastMessage( PlayerPawn(P).PlayerReplicationInfo.PlayerName$" tried to use his hidden admin status to play in godmode!!", false );
					else
						BroadcastMessage( PlayerPawn(P).PlayerReplicationInfo.PlayerName$" tried to use his admin status to play in godmode!!", false );
					PlayerPawn(P).ReducedDamageType = '';
					PlayerPawn(P).AdminLogout();
					}
				else if ( PlayerPawn(P).IsInState('PlayerFlying') )
					{
					//Admin is flying!!
					if ( bHiddenAdmin)
						BroadcastMessage( PlayerPawn(P).PlayerReplicationInfo.PlayerName$" tried to use his hidden admin status to cheatfly!!", false );
					else
						BroadcastMessage( PlayerPawn(P).PlayerReplicationInfo.PlayerName$" tried to use his admin status to cheatfly!!", false );
					PlayerPawn(P).GotoState('PlayerWalking');
					PlayerPawn(P).AdminLogout();
					}
				else if ( PlayerPawn(P).UnderwaterTime > 999998 )
					{
					//Admin is using the Amphibious cheat!!
					if ( bHiddenAdmin)
						BroadcastMessage( PlayerPawn(P).PlayerReplicationInfo.PlayerName$" tried to use his hidden admin status to play in Amphibious mode!!", false );
					else
						BroadcastMessage( PlayerPawn(P).PlayerReplicationInfo.PlayerName$" tried to use his admin status to play in Amphibious mode!!", false );
					PlayerPawn(P).UnderwaterTime = PlayerPawn(P).default.UnderwaterTime;
					PlayerPawn(P).AdminLogout();
					}
				//Check if admin is ammo cheating:
				bIsAmmoCheating = True;
				NumAmmo = 0;
				if ( !PlayerPawn(P).PlayerReplicationInfo.bIsSpectator && !PlayerPawn(P).PlayerReplicationInfo.bWaitingPlayer )
					{
					for( Inv=P.Inventory; Inv!=None; Inv=Inv.Inventory )
						{
						if (Ammo(Inv)!=None) 
							{
							if ( Ammo(Inv).AmmoAmount != 999 || Ammo(Inv).MaxAmmo  != 999)
								bIsAmmoCheating = False;
							NumAmmo++;
							}
						else if ( Inv.IsA('UT_JumpBoots') )
							bGotJumpBoots = True;	//used to detect JumpZ cheat later in scipt
						}
					if ( bIsAmmoCheating && NumAmmo > 0)
						{
						//Admin is using the Ammo cheat!!
						if ( bHiddenAdmin)
							BroadcastMessage( PlayerPawn(P).PlayerReplicationInfo.PlayerName$" tried to use his hidden admin status to use the AllAmmo cheat!!", false );
						else
							BroadcastMessage( PlayerPawn(P).PlayerReplicationInfo.PlayerName$" tried to use his admin status to use the AllAmmo cheat!!", false );
						PlayerPawn(P).AdminLogout();
						}
					}
				//Check if admin is using invisible cheat:
				if ( !PlayerPawn(P).PlayerReplicationInfo.bIsSpectator && !PlayerPawn(P).PlayerReplicationInfo.bWaitingPlayer && PlayerPawn(P).bHidden )
					{
					if ( bHiddenAdmin)
						BroadcastMessage( PlayerPawn(P).PlayerReplicationInfo.PlayerName$" tried to use his hidden admin status to use the invisible cheat!!", false );
					else
						BroadcastMessage( PlayerPawn(P).PlayerReplicationInfo.PlayerName$" tried to use his admin status to use the invisible cheat!!", false );
					PlayerPawn(P).bHidden = False;
					PlayerPawn(P).AdminLogout();
					}
				//Check if admin is using JumpZ cheat:
				if ( !PlayerPawn(P).PlayerReplicationInfo.bIsSpectator && !PlayerPawn(P).PlayerReplicationInfo.bWaitingPlayer && P.JumpZ != P.Default.JumpZ * Level.Game.PlayerJumpZScaling() && !bGotJumpBoots || P.JumpZ != P.Default.JumpZ * 3 && bGotJumpBoots )
					{
					if ( bHiddenAdmin)
						BroadcastMessage( PlayerPawn(P).PlayerReplicationInfo.PlayerName$" tried to use his hidden admin status to use the JumpZ cheat!!", false );
					else
						BroadcastMessage( PlayerPawn(P).PlayerReplicationInfo.PlayerName$" tried to use his admin status to use the JumpZ cheat!!", false );
					P.JumpZ = P.Default.JumpZ * Level.Game.PlayerJumpZScaling();
					PlayerPawn(P).AdminLogout();
					}
				}
			else if ( bNoFeigningDeath && PlayerPawn(P).PlayerReplicationInfo.bFeigningDeath )
				{
				//Disable the players ability to feign death:
				if ( PlayerPawn(P).IsInState('FeigningDeath') )
					{
					PlayerPawn(P).PlayerReplicationInfo.bFeigningDeath = False;
					PlayerPawn(P).GotoState('PlayerWalking');
					}
				if ( FeignDeathMessage != "" )
					P.ClientMessage(FeignDeathMessage, 'FeignDeath');
				}
			}
		}	
}

defaultproperties
{
DMGameName="-= DeathMatch =-"
TDMGameName="-= Team DeathMatch =-"
CTFGameName="-= Capture The Flag =-"
DOMGameName="-= Domination =-"
ASGameName="-= Assault =-"
DMLeftMessage=" is a quitter!"
TDMLeftMessage=" is a quitter!"
CTFLeftMessage=" is a quitter!"
DOMLeftMessage=" is a quitter!"
ASLeftMessage=" is a quitter!"
DMEnteredMessage=" joined the fun!"
TDMEnteredMessage=" joined the fun!"
CTFEnteredMessage=" joined the fun!"
DOMEnteredMessage=" joined the fun!"
ASEnteredMessage=" joined the fun!"
bUseGlobalStats=True
GlobalStatsURL="http://www.globalstats.unrealtournament.info"
GlobalStatsPath"/Serverlink/link.php"
bNulledCarcasses=False
bAllWeapons=False
bGiveRedeemer=False
bNoInvisibility=False
bNoArmor=False
bNoThighPads=False
bNoDamageAmplifier=False
bNoShieldbelt=False
bNoJumpboots=False
bNoHealthvials=False
bNoMedBoxes=False
bNoSuperHealth=False
NumJumps=3
bHeadShotBonus=True
HeadShotHealthReward=10
HeadShotMaxHealth=250
HeadShotFragBonus=5
HeadShotAmmoReward=10
bIgnoreMaxAmmo=True
bUseRevenge=True
RevengeHealthReward=10
RevengeMaxHealth=250
RevengeFragBonus=1
RevengeAmmoReward=5
bIgnoreMaxAmmoR=True
bPinata=True
bSoulmode=True
bIgnoreMaxAmmoC=True
LifeTime=60
SoulScore=1
SoulHealth=10
SoulMaxHealth=250
SoulAmmo=10
SoulMessage="You claimed a soul!"
bHiddenAdmin=True
bNoFeigningDeath=False
FeignDeathMessage="You are not allowed to feign death on this server!"
ACEModDelay=10
}